/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (11/07/07)
 */    
package com.ejie.p06b.util;

import java.io.ByteArrayOutputStream;


import com.ejie.p06b.xml.generator.P06BMediadorXML;
import com.izenpe.AlgoritmosFirmaDigital;
import com.izenpe.firmaelectronica.FirmaElectronica;




/**
 * Esta clase representa un conjunto de mtodos para utilidades de firmas.
 */
public class P06BSignatureF {
	
	/*
	 * Mtodo de TEST de la clase con la estructura de Firma de
	 * la aplicacin.
	 * 
	 */
	public static void main(String[] args){
		try {
			ByteArrayOutputStream resultado = P06BSignatureF.createSimpleSignature(P06BMediadorXML.getXmlSimulate());
			ByteArrayOutputStream resultado2 = P06BSignatureF.createSimpleSignature("EJEMPLO");
		} catch (Exception e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
	}
	/*
	 * Mtodo que recibe un texto y realiza una firma simple mediante el API de izempe
	 * 
	 * Se le debe pasar el String con el texto que se desea firmar
	 * 
	 * Devuelve un ByteArrayOutputStream con el texto firmado
	 * 
	 * Lanza una excepcin si no se ha podido realizar la firma
	 * 
	 */
	public static ByteArrayOutputStream createSimpleSignature(String document)
		      throws Exception {
		 
		      FirmaElectronica izenpeSignature = new FirmaElectronica();
		      int errorCode;
		      ByteArrayOutputStream simpleSignature = new ByteArrayOutputStream();
		      AlgoritmosFirmaDigital signatureAlgorithm = new AlgoritmosFirmaDigital();
		      
		      //Obtenemos la informacin para invocar al API de IZENPE
		      //El password del keystore
		      String keyStorePass = P06BParametros.get("firma.keyStorePass");
		      //El path del keystore
		      String keyStorePath = P06BParametros.get("firma.keyStorePath");
		      //Miramos en el generadorCS:
		      //	- El issuer
		      //	- subject
		      String issuer = P06BParametros.get("firma.issuer");
		      String subject = P06BParametros.get("firma.subject");
		      //FIN Miramos en el generadorCS
		      
		      //Creamos el algoritmo a utilizar en la encriptacin
		      String algorithm = P06BParametros.get("firma.algorithm");
		      signatureAlgorithm.setAlgorithm(algorithm);
		     
		      //Invocamos al mtodo de firma de IZENPE
		      
		      //Se podra comentar al incorporar ivy.xml porque precisa iaik.asn1.structures.AlgorithmID 
		      //inicialmente disponible en C:\aplic\p06b\p06bEAR\EarContent\APP-INF\lib\iaik_jce.jar
		      //y que no se ha podido localizar en http://repository.ejiedes.net
		      errorCode =
		         izenpeSignature.signDettached(
		         	issuer,
		         	subject,
		            signatureAlgorithm.getAlgorithm(),
		            document.getBytes(),
		            keyStorePath,
		            keyStorePass,
		            null,
		            simpleSignature,true);
		      //Si se ha producido un error lanzamos una excepcin
		      if (errorCode != 0)
		            throw new Exception("IzenpeErrorCode(" + errorCode+") " +
		                errorCode);
		      //Devolvemos el documento firmado
		      return simpleSignature;
		   }
}